<?php

require_once 'bootstrap.php';
session_start();

$action = $_GET['action'] ?? 'connexion';

switch ($action) {

    //connexion
    case 'connexion':
        require 'view/connexion.php';
        break;

    //traite connexion
    case 'traite_login':
        require 'view/traite_login.php';
        break;

    //accueil
    case 'accueil':
        if (isset($_SESSION['id_user']) && $_SESSION['id_user'] === 1){
            require 'view/accueil_admin.php';
        }else{
            require 'view/accueil.php';
        }
        break;

    //administration
    case 'admin':
        if (isset($_SESSION['id_user']) && $_SESSION['id_user'] === 1){
            require 'view/admin.php';
        }
        break;
    
    //profil 
    case 'profil':
        if (isset($_SESSION['id_user'])) {
            $id = $_SESSION['id_user'];
            
            $UserController = new UserController($entityManager);
            $user = $UserController->getUserById($id);
            
            $coms = $UserController->getCommentairesByUserId($id);
    
            if ($user) {
                require 'view/profil.php';
            }
        }
        break;
    
    //déconnexion 
        case 'deconn':
            $_SESSION = [];
            session_destroy();
            header('Location: index.php');
            exit();
            break;
        
    //affichage des billets 
    case 'billet_affiche':
        if (isset($_GET['id_billet'])) {
            $id = $_GET['id_billet'];
            $BilletController = new BilletController($entityManager);
            $billet = $BilletController->getBilletById($id);
            $coms = $BilletController->getCommentairesByBilletId($id);

            if ($billet) {
                require 'view/billet_affiche.php';
            } else {
                echo "Billet introuvable.";
            }
        }
        break;

    //ajout de billets
    case 'add_billet':
        if (isset($_SESSION['id_user']) && $_SESSION['id_user'] === 1){
            if (isset($_POST['titre']) && isset($_POST['contenu'])){
                $titre = $_POST['titre'];
                $contenu = $_POST['contenu'];

                $BilletController = new BilletController($entityManager);
                $BilletController->add_billet($titre, $contenu);
            }
        }
        header('Location: index.php?action=accueil');
        break; 
        
    //ajout de commentaires
    case 'add_com':
        if (isset($_SESSION['id_user'])){
            if (isset($_POST['contenu']) && isset($_POST['id_billet'])){
                $contenu = $_POST['contenu'];
                $id_billet = $_POST['id_billet'];

                $ComsController = new ComsController($entityManager);
                $ComsController->add_com($contenu, $id_billet);
            }else {
                echo "Valeurs manquantes";
            } 
        }else {
            echo "Vous n'êtes pas connecter donc vous ne pouvez pas créer de billets";
        }
        header('Location: index.php?action=billet_affiche&id_billet=' . $_POST['id_billet']);
        break;
    
    //ajout d'utilisateurs 
    case 'add_user':
        if (isset($_POST['add_user'])) {

            $login = $_POST['login'];
            $mdp = $_POST['mdp'];

            $UserController = new UserController($entityManager);
            $UserController->add_user($login, $mdp);
    
            header("Location: index.php?action=admin");
            exit();
        }
        break;

        //inscription-view
        case 'inscription-view':
            require 'view/inscription.php';
            break;

        //inscription 
        case 'inscription':
            if (isset($_POST['inscription'])) {

                    $login = $_POST['login'];
                    $mdp = $_POST['mdp'];
        
                    $UserController = new UserController($entityManager);
                    $UserController->add_user($login, $mdp);
            
                    header("Location: index.php?action=connexion");
                    exit();
                }
                break;

            //modifier un billet 
            case 'modify_billet': 
                if (isset($_SESSION['id_user']) && $_SESSION['id_user'] === 1){
                    if (isset($_POST['id'])){
                        $id = $_POST['id'];
                        $titre = $_POST['titre'];
                        $contenu = $_POST['contenu'];
                        
                        $BilletController = new BilletController($entityManager);
                        $BilletController->modify_billet($id, $titre, $contenu);

                        header("Location: index.php?action=admin");
                        exit();
                    }
                }
                break;

            //modifier un commentaire 
            case 'modify_com':
                if(isset($_POST['id_com'])){
                    $id = $_POST['id_com'];
                    $contenu = $_POST['contenu'];

                    $ComsController = new ComsController($entityManager);
                    $ComsController->modify_com($id, $contenu);

                    header('Location: index.php?action=profil&valid_mod_com=on');
                    exit();
                }
                break;

            //modifier un utilisateur
            case 'modify_user':
                if(isset($_POST['id_user'])){
                    $id_user = $_POST['id_user'];
                    $login = $_POST['login'];
                    $mdp = $_POST['mdp'];

                    $UserController = new UserController($entityManager);
                    $UserController->modify_user($id_user, $login, $mdp);
                }
                header('Location: index.php?action=profil&valid_mod=on');
                break;

            //supprimer un billet 
            case 'supr_billet': 
                $id = $_GET['id'];
                $BilletController = new BilletController($entityManager);
                $BilletController->supr_billet($id);
                header('Location: index.php?action=admin');
                break;
            
            //supprimer un commentaire admin 
            case 'supr_com_admin': 
                $id = $_GET['id'];
                $ComsController = new ComsController($entityManager);
                $ComsController->supr_com($id);
                header('Location: index.php?action=admin');
                break;
            
            //supprimer un commentaire profil
            case 'supr_com_profil':
                $id = $_GET['id'];
                $ComsController = new ComsController($entityManager);
                $ComsController->supr_com($id);
                header('Location: index.php?action=profil');
                break;
            
            //supprimer un utilisateur 
            case 'supr_user':
                if (isset($_GET['id']) && $_GET['id'] === '1') {
                    header('Location: index.php?action=admin&err_supr=on');
                } else {
                    $id = $_GET['id'];
                    $UserController = new UserController($entityManager);
                    $UserController->supr_user($id);
                    header('Location: index.php?action=admin');
                }
                
                break;                
}

?>