<?php
Use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity]
class Billets {
    #[ORM\Id]
    #[ORM\Column(type: 'integer')]
    #[ORM\GeneratedValue]
    protected int|null $id = null;
    #[ORM\ManyToOne(targetEntity: User::class)]
    #[ORM\JoinColumn(nullable: false)]
    private $auteur;
    #[ORM\Column(type: 'string')]
    protected $titre;
    #[ORM\Column(type: 'string')]
    protected $contenu;
    #[ORM\Column(type: 'datetime')]
    protected $date_post;


    //Getters
    public function getId(){
        return $this->id;
    }

    public function getAuteur(){
        return $this->auteur;
    }

    public function getTitre(){
        return $this->titre;
    }

    public function getContenu(){
        return $this->contenu;
    }

    public function getDatePost(){
        return $this->date_post;
    }

    //Setters
    public function setId($id){
        $this->id=$id;
    }

    public function setAuteur($auteur){
        $this->auteur=$auteur;
    }

    public function setTitre($titre){
        $this->titre=$titre;
    }

    public function setContenu($contenu){
        $this->contenu=$contenu;
    }

    public function setDatePost(\DateTime $date)
    {
        $this->date_post = $date;
    }

}

?>