<?php

Use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity]
class Coms {
    #[ORM\Id]
    #[ORM\Column(type: 'integer')]
    #[ORM\GeneratedValue]
    private int|null $id = null;
    #[ORM\ManyToOne(targetEntity: User::class)]
    #[ORM\JoinColumn(nullable: false)]
    private $auteur;
    #[ORM\ManyToOne(targetEntity: Billets::class)]
    #[ORM\JoinColumn(nullable: false)]
    private $billet;
    #[ORM\Column(type: 'string')]
    protected $contenu;
    #[ORM\Column(type: 'datetime')]
    protected $datePost;

    //Getters
    public function getId(){
        return $this->id;
    }

    public function getAuteur(){
        return $this->auteur;
    }

    public function getBillet(){
        return $this->billet;
    }

    public function getContenu(){
        return $this->contenu;
    }

    public function getDatePost(){
        return $this->datePost;
    }

    //Setters
    public function setId($id){
        $this->id=$id;
    }

    public function setAuteur($auteur){
        $this->auteur=$auteur;
    }

    public function setBillet($billet){
        $this->billet=$billet;
    }

    public function setContenu($contenu){
        $this->contenu=$contenu;
    }

    public function setDatePost(\DateTime $datePost)
    {
        $this->datePost = $datePost;
    }

}