<?php

Use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity]
class User {
    #[ORM\Id]
    #[ORM\Column(type: 'integer')]
    #[ORM\GeneratedValue]
    protected int|null $id = null;
    #[ORM\Column(type: 'string')]
    protected string $login;
    #[ORM\Column(type: 'string')]
    protected string $mdp;
    #[ORM\Colume(type: 'string')]
    #[ORM\JoinColumn(nullable: true)]
    protected string $image;

    //Getters

    public function getId(){
       return $this->id;
    }
    
    public function getLogin(){
        return $this->login;
     }

    public function getMdp(){
        return $this->mdp;
     }

    public function getImage(){
        return $this->image;
    }


    //Setters

    public function setId($id){
        $this->id=$id;
    }

    public function setLogin($login){
        $this->login=$login;
    }

    public function setMdp($mdp){
        $this->mdp = password_hash($mdp, PASSWORD_BCRYPT);
    }

    public function setImage($image){
        $this->image=$image;
    }
}
?>
