<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Connexion</title>
    <style>
        /* Style de base pour la page */
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            margin: 0;
            padding: 20px;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }

        .message-container {
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            padding: 30px;
            width: 100%;
            max-width: 400px;
            text-align: center;
        }

        /* Style du message de connexion et des liens */
        .message {
            font-size: 18px;
            color: #333333;
            margin-bottom: 20px;
        }

        .success {
            color: #2ecc71;
        }

        .error {
            color: #e74c3c;
        }

        .link {
            display: inline-block;
            margin-top: 15px;
            padding: 10px 20px;
            font-size: 16px;
            font-weight: bold;
            color: #3498db;
            text-decoration: none;
            border: 2px solid #3498db;
            border-radius: 5px;
            transition: background-color 0.3s, color 0.3s;
        }

        .link:hover {
            background-color: #3498db;
            color: #ffffff;
        }
    </style>
</head>
<body>

<div class="message-container">
<?php
if (isset($_POST['login']) && isset($_POST['mdp'])) {
    $login = $_POST['login'];
    $mdp = $_POST['mdp'];

    $utilisateur = $entityManager->getRepository(User::class)->findOneBy(['login' => $login]);

    if ($utilisateur) {
        if (password_verify($mdp, $utilisateur->getMdp())) {
            echo "<div class='message success'>Vous êtes connecté. Bienvenue {$utilisateur->getLogin()}</div>";
            
            $_SESSION["login"] = $utilisateur->getLogin();
            $_SESSION["id_user"] = $utilisateur->getId();

            echo "<a href=\"index.php?action=accueil\" class=\"link\">Page d'accueil</a>";
        } else {
            echo "<div class='message error'>Mot de passe incorrect</div>";
            echo "<a href=\"index.php?action=connexion\" class=\"link\">Retentez votre chance !</a><br>";
            echo "<a href=\"index.php?action=inscription\" class=\"link\">Ou inscrivez-vous !</a>";
        }
    } else {
        echo "<div class='message error'>Login incorrect</div>";
        echo "<a href=\"index.php?action=connexion\" class=\"link\">Retentez votre chance !</a><br>";
        echo "<a href=\"index.php?action=inscription\" class=\"link\">Ou inscrivez-vous !</a>";
    }
} else {
    echo "<div class='message error'>Login ou mot de passe manquant</div>";
    echo "<a href=\"index.php?action=connexion\" class=\"link\">Retentez votre chance !</a><br>";
    echo "<a href=\"index.php?action=inscription\" class=\"link\">Ou inscrivez-vous !</a>";
}
?>

</div>

</body>
</html>

